#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""

       Universite catholique de Louvain
       CEREM : Centre for research in mechatronics
       http://www.robotran.be
       Contact : info@robotran.be


       Main script template for complete model:
       -----------------------------------------------
        This template loads the data file *.mbs and execute:
          - the coordinate partitioning module
          - the direct dynamic module (time integration of
            equations of motion).
          - the equilibrium module
          - the modal module
          - the inverse dynamic module
          - the solverkin module
        It may be adapted and completed by the user.

        (c) Universite catholique de Louvain

"""

#==============================================================================
# Packages loading
#==============================================================================
import sys
sys.path.insert(1,"./../../../../mbsysc/MBsysC/build/python") # Relative path for this example script

import MBsysPy as Robotran
import numpy as np

#==============================================================================
# Project loading
#==============================================================================
mbs_file = "./../dataR/delta_fisette_python.mbs"
print(type(mbs_file))
mbs_data = Robotran.MbsData(mbs_file)
# print(mbs_data)
#
#print(mbs_data.njoint,mbs_data.nbody)

#====
# User constraints
#====
mbs_data.set_nb_userc(3)

#==============================================================================
# Partitionning
#==============================================================================
mbs_data.process = 1

mbs_data.set_qu([1,2,3]) # ind. coordinates

mbs_part = Robotran.MbsPart(mbs_data)
mbs_part.set_options(rowperm = 1, verbose = 1)
mbs_part.run()

mbs_data.q[4:] = np.mod(mbs_data.q[4:],2*np.pi) # Suppresion of 2*k*pi

print(mbs_data)


# # ==============================================================================
# # Equilibrium
# # ==============================================================================
# mbs_data.process = 2
# mbs_equil = Robotran.MbsEquil(mbs_data)
# mbs_equil.set_options(method = 1, senstol = 1e-2, verbose = 1)
# mbs_equil.run()

# # ==============================================================================
# # Modal Analysis
# # ==============================================================================
# mbs_data.process = 4
# mbs_modal = Robotran.MbsModal(mbs_data)
# mbs_modal.set_options(save_result = 1, save_anim = 1, mode_ampl = 0.2)
# mbs_modal.run()

# # ==============================================================================
# # Direct Dynamics
# # ==============================================================================
# mbs_data.process = 3
# mbs_dirdyn = Robotran.MbsDirdyn(mbs_data)
# mbs_dirdyn.set_options(dt0 = 1e-3, tf = 10.0, save2file = 1)
# mbs_dirdyn.run()

#==============================================================================
# Inverse Kinematics
#==============================================================================

mbs_data.process = 5

mbs_data.set_qdriven([1,2,3])

mbs_solvekin = Robotran.MbsSolvekin(mbs_data)
#mbs_solvekin.set_options(trajectoryqname = "../resultsR/dirdyn_q.res")
#mbs_solvekin.set_options(trajectoryqdname = "../resultsR/dirdyn_qd.res")
#mbs_solvekin.set_options(trajectoryqddname = "../resultsR/dirdyn_qdd.res")
mbs_solvekin.set_options(t0 = 0.0, tf = 5.0, dt = 1e-2, framerate = 1000)
mbs_solvekin.set_options(motion = "trajectory", store_results=False)

mbs_solvekin.run()

# print(mbs_data)

#==============================================================================
# Inverse Dynamics
#==============================================================================
mbs_data.process = 6

mbs_data.set_qu([10,15,20])
mbs_data.set_qv([1,2,3])

mbs_invdyn = Robotran.MbsInvdyn(mbs_data)
mbs_invdyn.set_options(trajectoryqname = "../resultsR/solvekin_q.res")
mbs_invdyn.set_options(trajectoryqdname = "../resultsR/solvekin_qd.res")
mbs_invdyn.set_options(trajectoryqddname = "../resultsR/solvekin_qdd.res")
#mbs_invdyn.set_options(t0 = 0.0, tf = 10.0, dt = 1e-3)
mbs_invdyn.set_options(motion="trajectory")
mbs_invdyn.run()
